//
//  TransactionViewController.m
//  ABC Bank
//
//  Created by oliviers on 10/13/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "TransactionViewController.h"
#import "TransactionViewCell.h"

@interface TransactionViewController ()
{
    BOOL touchCapture;
}
@end

@implementation TransactionViewController

@synthesize store;

- (void)createNavButtons
{
    NSString * callTitle = @"Call";
    
    UIBarButtonItem * callButton;
    callButton = [[UIBarButtonItem alloc] initWithTitle:callTitle style:UIBarButtonItemStyleBordered target:self action:@selector(callPressed:)];
    self.navigationItem.rightBarButtonItems = [NSArray arrayWithObjects:callButton, nil];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBarHidden = NO;
    self.navigationItem.title = store.name;
    
    [self createNavButtons];
}


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return store.allItems.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    TransactionViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"TransactionViewCell"];
    if(!cell){
        
        cell = [[TransactionViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"TransactionViewCell"];
    }
    
    Transaction* t = [store.allItems objectAtIndex:[indexPath row]];
    NSDateFormatter * dateFormatter = [[NSDateFormatter alloc] init];
    dateFormatter.dateStyle = NSDateFormatterShortStyle;

    NSNumberFormatter * numberFormatter = [[NSNumberFormatter alloc] init];
    numberFormatter.numberStyle = NSNumberFormatterCurrencyStyle;
    
    cell.date.text = [dateFormatter stringFromDate:t.dateCreated];
    cell.name.text = t.itemName;
    cell.transactionID.text = t.transactionId;
    cell.amount.text = [numberFormatter stringFromNumber:t.amount];
    
    return cell;
}

#pragma mark - Table view delegate

- (IBAction)callPressed:(id)sender
{
    
    CJGuestCallViewController * cc = [[CJGuestCallViewController alloc] init];
    
    cc.serverName = [CJGuestCall sharedInstance].serverName;
    cc.toURI = [CJGuestCall sharedInstance].toURI;
    
    cc.delegate = self;
    
    [[self navigationController] pushViewController:cc animated:YES];
}

#pragma mark CallControllerDelegate
- (void)callFinishedForCallController:(CJGuestCallViewController *)callController
{
    [self.navigationController popViewControllerAnimated:YES];
}

@end
